// $Id: CStepLabel.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CStepLabel.hpp"
using Exponent::GUI::Controls::CStepLabel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CStepLabel, CTextLabel);

//	===========================================================================
CStepLabel::CStepLabel(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
		  : CTextLabel(root, uniqueId, area, " ")
		  , m_stringArray(NULL)
		  , m_wrapStrings(false)
		  , m_currentStringIndex(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CStepLabel);
	m_stringArray        = new TStringCountedPointerArray();
	this->registerActionListener(listener);
	this->controlIsDropFileEnabled(false);
}

//	===========================================================================
CStepLabel::~CStepLabel()
{
	EXPONENT_CLASS_DESTRUCTION(CStepLabel);
	FREE_POINTER(m_stringArray);
}

//	===========================================================================
void CStepLabel::addString(const CString &string)
{
	m_stringArray->addElement(new CString(string));
}

//	===========================================================================
void CStepLabel::nextString()
{
	m_currentStringIndex++;
	if (m_currentStringIndex < m_stringArray->getArraySize())
	{
		// Then we can string get the string and set it
		CString *string = m_stringArray->elementAtIndex(m_currentStringIndex);//>stringAtIndex();
		if (string)
		{
			this->setText(*string);
		}
	}
	else
	{
		if (m_wrapStrings)
		{
			m_currentStringIndex = 0;
			CString *string = m_stringArray->elementAtIndex(m_currentStringIndex);//(CString *)m_stringArray->stringAtIndex(m_currentStringIndex);
			if (string)
			{
				this->setText(*string);
			}
		}
		else
		{
			m_currentStringIndex--;
		}
	}

	// Notify the listener
	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this));
	}
}

//	===========================================================================
void CStepLabel::previousString()
{
	m_currentStringIndex--;
	if (m_currentStringIndex >= 0)
	{
		// Then we can string get the string and set it
		CString *string = m_stringArray->elementAtIndex(m_currentStringIndex);//(CString *)m_stringArray->stringAtIndex(m_currentStringIndex);
		if (string)
		{
			this->setText(*string);
		}
	}
	else
	{
		if (m_wrapStrings)
		{
			m_currentStringIndex = m_stringArray->getArraySize() - 1;
			CString *string = m_stringArray->elementAtIndex(m_currentStringIndex);//(CString *)m_stringArray->stringAtIndex(m_currentStringIndex);
			if (string)
			{
				this->setText(*string);
			}
		}
		else
		{
			m_currentStringIndex = 0;
		}
	}

	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this));
	}
}

//	===========================================================================
void CStepLabel::setStep(const long step)
{
	if (step >= 0 && step < m_stringArray->getArraySize())
	{
		m_currentStringIndex = step;
		CString *string = m_stringArray->elementAtIndex(m_currentStringIndex);//(CString *)m_stringArray->stringAtIndex(m_currentStringIndex);
		if (string)
		{
			this->setText(*string);
		}
	}
}

//	===========================================================================
void CStepLabel::handleActionEvent(const CActionEvent &event)
{
	if (event.getControl()->getUniqueId() == e_stepIncrementButton)
	{
		this->nextString();
	}
	else if (event.getControl()->getUniqueId() == e_stepDecrementButton)
	{
		this->previousString();
	}
}